/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1986 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
 * Name:
 *	SPBlockDebug.h
 *
 *
 * Purpose:
 *	SP Block Debug Suite.
 *
 * Distribution:
 *	PUBLIC
 *
 * Version history:
 *	1.0.0 4/1/1995	DL	First version.
 *		Created by Adobe Systems Incorporated.
 */

#ifndef __SPBlockDebug__
#define __SPBlockDebug__


/*******************************************************************************
 **
 **	Imports
 **
 **/

#include "SPTypes.h"

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************************************
 **
 **	Constants
 **
 **/

#define kSPBlockDebugSuite			"SP Block Debug Suite"
#define kSPBlockDebugSuiteVersion	2


/*******************************************************************************
 **
 **	Suite
 **
 **/

typedef struct SPBlockDebugSuite {

	SPAPI SPErr (*GetBlockDebugEnabled)( long *enabled );
	SPAPI SPErr (*SetBlockDebugEnabled)( long debug );
	SPAPI SPErr (*GetFirstBlock)( void **block );
	SPAPI SPErr (*GetNextBlock)( void *block, void **nextblock );
	SPAPI SPErr (*GetBlockDebug)( void *block, char **debug );

} SPBlockDebugSuite;


SPAPI SPErr SPGetBlockDebugEnabled( long *enabled );
SPAPI SPErr SPSetBlockDebugEnabled( long debug );
SPAPI SPErr SPGetFirstBlock( void **block );
SPAPI SPErr SPGetNextBlock( void *block, void **nextblock );
SPAPI SPErr SPGetBlockDebug( void *block, char **debug );


/*******************************************************************************
 **
 **	Errors
 **
 **/

#include "SPErrorCodes.h"

#ifdef __cplusplus
}
#endif

#endif
